﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading;

namespace CpuUsageComparison
{
    // Listing 16-8. Rozwiązanie wielowątkowe oraz jednowątkowe
    class Program
    {
        static int Count;
        const int Iterations = 1000000000;
        static void Go()
        {
            for (int i = 0; i < Iterations; ++i)
            {
                Interlocked.Increment(ref Count);
            }
        }
        static void GoSingle(int repeat)
        {
            for (int outer = 0; outer < repeat; ++outer)
            {
                for (int i = 0; i < Iterations; ++i)
                {
                    Count += 1;
                }
            }
        }

        static void Main(string[] args)
        {
            //RunMultithreaded();
            RunSinglethreaded();
        }

        private static void RunMultithreaded()
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            Count = 0;
            List<Thread> threads = (from i in Enumerable.Range(0, 4)
                                    select new Thread(Go)).ToList();
            threads.ForEach(t => t.Start());
            threads.ForEach(t => t.Join());

            sw.Stop();
            Console.WriteLine("Wykonano z użyciem wielu wątków. Liczba: {0}, czas: {1}", Count, sw.Elapsed);
        }

        private static void RunSinglethreaded()
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            Count = 0;
            GoSingle(4);

            sw.Stop();
            Console.WriteLine("Wykonano z użyciem jednego wątku. Liczba: {0}, Czas: {1}", Count, sw.Elapsed);
        }
    }
}
